//	CFolderURL.h

#ifndef _H_CFolderURL
#define _H_CFolderURL

#include "CFolder.h"
#include "CGenerator.h"

class			CFolderUrl;
typedef struct	Gen_Item Gen_Item;

typedef		OSErr	URL_ForEachEntryCB(
	CFolderUrl			*thiz, 
	Gen_Item			*itemP, 
	EntryIndex			entryIndex, 
	Boolean				*done, 
	void				*data);

class CFolderUrl : public CFolder {

	public:	
	
	OSErr	IFolderUrl(
		CDiskUrl			*urlDiskP, 
		CFolderUrl			*urlParentFolderP, 
		Gen_Item			*itemP, 
		EntryIndex			directoryIndex);

	virtual	void	Dispose(void);
	
			OSErr			ForEachEntry(URL_ForEachEntryCB URL_ForEachUserCB, void *data);
			Boolean			GetUniqueName(char *fileName);

	static	OSErr	Url_MakeNewEntryCB(
				CFolderUrl			*thiz, 
				Gen_Item			*itemP, 
				EntryIndex			indexL, 
				Boolean				*done, 
				void				*data);
			
			//	returns TRUE if success
			OSErr			MakeNewEntry(
				Gen_Item			*itemP, 
				EntryIndex			indexL, 
				Gen_MakeEntryData	*dataP, 
				CEntry				**newEntry0 = NULL, 
				Boolean				verifyB = TRUE);
				
	virtual	void			ConformStrLen(char* nameStr);

	virtual	char			*GetDescription(char *buf);

	virtual	void			SetName(char *buf);
	virtual	DateTimeRec		*GetCreatedTime(DateTimeRec *dt);
	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	void			SetCreatedTime(DateTimeRec *dt);
	virtual	void			SetModifiedTime(DateTimeRec *dt);
	virtual	DateTimeRec		*GetModifiedTimeRemote(DateTimeRec *dt);
	virtual	void			RemoteChanged(void);

	virtual	char			*GetName(char *buf);
	
	virtual	OSErr			NewFile(Boolean isFolder, CEntry **entryH);
	virtual	OSErr			NewFolder(CEntry **newFolderH);

	virtual	void			GetAccessBits(Gen_AccessBits *bits);
	virtual	void			SetAccessBits(Gen_AccessBits *bits);

	virtual	OSErr			PutFileNewEntry(Handle fileH);

	void			SetTwirled(Boolean twirledB);	
	Boolean			GetTwirled(void);

	OSErr			URL_DeleteEntry(short dirIndex);
		
	CEntry			*GetEntryFromItem(Gen_Item *itemP);

	virtual	Boolean		IsDeleted(void);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);

	virtual	ulong		GetPhysicalSize(void);
	virtual	ulong		GetLogicalSize(void);

	virtual	ADFS_IconType	GetIconType(void);
	virtual	OSErr		AddEntries(Boolean normalB, Boolean deletedB);
	
	virtual	void		Open(void);

	/******************************************/
	Boolean			i_roseDocB;
	Handle			i_iconSuiteH;
	
	Gen_Item		*i_itemP;
	CGenerator		*i_generatorP;
	
	private:
	typedef CFolder _inherited;
};


#endif
